const Scene_ShopItemList = require('./ShopList');

class Scene_OrangeTownGeneralStoreCrops extends Scene_ShopItemList {
  addSpringCrops() {
    this.addItem('turnip');
    this.addItem('potato');
    this.addItem('cucumber');

    if (Switches.canBuyStrawberrySeeds) {
      this.addItem('strawberry');
    }
  }

  addSummerCrops() {
    this.addItem('onion');
    this.addItem('corn');
    this.addItem('tomato');

    if (Switches.canBuyChillipepperSeeds) {
      this.addItem('chillipepper');
    }

    if (Switches.canBuyCassavaSeeds) {
      this.addItem('cassava');
    }

    if (Switches.canBuyGrapeSeeds) {
      this.addItem('grape');
    }

    if (Switches.canBuyWatermelonSeeds) {
      this.addItem('watermelon');
    }
  }

  addFallCrops() {
    this.addItem('carrot');
    this.addItem('eggplant');
    this.addItem('sweet-potato');

    if (Switches.canBuyBeetSeeds) {
      this.addItem('beet');
    }

    if (Switches.canBuyBroccoliSeeds) {
      this.addItem('broccoli');
    }

    if (Switches.canBuyPeanutSeeds) {
      this.addItem('peanut');
    }

    if (Switches.canBuySpinachSeeds) {
      this.addItem('spinach');
    }

    if (Switches.canBuyRadishSeeds) {
      this.addItem('radish');
    }

    if (Switches.canBuyBellpepperSeeds) {
      this.addItem('bellpepper');
    }

    if (Switches.canBuyPumpkinSeeds) {
      this.addItem('pumpkin');
    }
  }

  addWinterCrops() {
    this.addItem('lettuce');
    this.addItem('leek');
    this.addItem('cauliflower');
  }

  addOtherCrops() {
    this.addItem('sugarcane');
    this.addItem('wheat');

    if (Switches.canSellMushroomSeeds) {
      this.addItem('mushroom');
    }
  }

  makeItemList() {
    this._container.clear();

    switch(Managers.Time.month) {
      case Seasons.SPRING:
        this.addSpringCrops();
        break;
      case Seasons.SUMMER:
        this.addSummerCrops();
        break;
      case Seasons.FALL:
        this.addFallCrops();
        break;
      case Seasons.WINTER:
        this.addWinterCrops();
        break;
    }

    this.addOtherCrops();
  }
}

GameScenes.OrangeTownGeneralStoreCrops = Scene_OrangeTownGeneralStoreCrops;
module.exports = Scene_OrangeTownGeneralStoreCrops;