const Scene_MenuBase = require('engine/scenes/Scene_MenuBase');
const Window_ShopCommand = require('../../windows/shop/ShopCommand');
const Window_AnimalsToRetrieve = require('../../windows/shop/AnimalsToRetrieve');

class Scene_AnimalsToRetrieve extends Scene_MenuBase {
  prepare(animalTypes) {
    this._animalTypes = animalTypes;

    Managers.Images.loadBackground('animal_vet_layout');
    Managers.Images.loadPicture('shop/animal_vet_retrieve_slot');
  }

  terminate() {
    Managers.Images.releaseBackground('animal_vet_layout');
    Managers.Images.releasePicture('shop/animal_vet_retrieve_slot');
    super.terminate();
  }

  create() {
    super.create();
    this.createAnimalListWindow();
    this.createCloseButton();
    this.createCommandWindow();
  }

  animal() {
    return this._animalListWindow.animal();
  }

  createCloseButton() {
    super.createCloseButton();
    this._closeButtonWindow.x = this._animalListWindow.x + this._animalListWindow.width - this._closeButtonWindow.width - (5 * Graphics.windowZoomLevel);
    this._closeButtonWindow.y = this._animalListWindow.y + (22 * Graphics.windowZoomLevel);
  }

  onClickCancelButton() {
    super.onClickCancelButton();
    Managers.Villagers.playDialogue('Mia', 'no_animal_retrieved');
  }

  createBackground() {
    const bitmap = Managers.Scenes.backgroundBitmap();
    if (bitmap == null) {
      this._backgroundSprite = new Sprite(this.loadingBgBitmap());
      this._backgroundSprite.scale.x = this._backgroundSprite.scale.y = this.screenRatio;
      this._backgroundSprite.x = this.backgroundX();
    } else {
      this._backgroundSprite = new Sprite(bitmap);
    }

    this.addChild(this._backgroundSprite);
    this.setBackgroundOpacity(this.backgroundOpacity());
  }

  createAnimalListWindow() {
    this._animalListWindow = new Window_AnimalsToRetrieve(this._animalTypes);
    this._animalListWindow.setHandler('ok', this.onAnimalOk.bind(this));
    this._animalListWindow.setHandler('cancel', this.onAnimalCancel.bind(this));
    this.addWindow(this._animalListWindow);
    this._animalListWindow.select(0);
    this.activateAnimalListWindow();
  }

  onAnimalCancel() {
    Managers.Scenes.pop();
    Managers.Villagers.playDialogue('Mia', 'no_animal_retrieved');
  }

  activateAnimalListWindow() {
    this._animalListWindow.refresh();
    this._animalListWindow.activate();
  }

  createCommandWindow() {
    this._commandWindow = new Window_ShopCommand();
    this._commandWindow.setHandler('retrieve', this.onRetrieveOk.bind(this));
    this._commandWindow.setHandler('cancel', this.onBuyCancel.bind(this));
    this._commandWindow.hide();
    this._commandWindow.deactivate();
    this._commandWindow.setMode('retrieve');
    this.addWindow(this._commandWindow);
  }

  closeCommandWindow() {
    this._commandWindow.hide();
    this._commandWindow.deactivate();
    this.activateAnimalListWindow();
  }

  onRetrieveOk() {
    const creature = this.animal();
    if (!creature) {
      Managers.Sound.playBuzzer();
      this.closeCommandWindow();
      return;
    }

    const position = Managers.Creatures.findRoomForCreature(creature._type);
    if (!position) {
      Managers.Sound.playBuzzer();
      this.closeCommandWindow();
      return;
    }

    creature._homeMapId = position.mapId;
    creature._homeX = position.x;
    creature._homeY = position.y;

    Managers.Creatures.moveAnimal(creature, position.mapId, position.x, position.y);
    Managers.Sound.playOk();

    Variables.animalName = creature.creatureName;

    const realMapId = Managers.Map.getRealMapId(position.mapId);

    if (realMapId === Maps.COOP || realMapId === Maps.EXPANDED_COOP) {
      Managers.Villagers.playDialogue('Mia', 'animal_retrieved_coop');
    } else if (realMapId === Maps.BARN || realMapId === Maps.EXPANDED_BARN) {
      Managers.Villagers.playDialogue('Mia', 'animal_retrieved_barn');
    } else {
      Managers.Villagers.playDialogue('Mia', 'animal_retrieved');
    }

    this.popScene();
  }

  onBuyCancel() {
    this.closeCommandWindow();
  }

  onAnimalOk() {
    const creature = this.animal();
    if (!creature) {
      Managers.Sound.playBuzzer();
      this.activateAnimalListWindow();
      return;
    }

    const enoughRoom = Managers.Creatures.hasRoomForAnimal(creature._type);
    if (!enoughRoom) {
      Managers.Sound.playBuzzer();
      this.activateAnimalListWindow();
      return;
    }

    this._animalListWindow.deactivate();
    this._commandWindow.show();
    this._commandWindow.activate();
    this._commandWindow.select(1);
  }
}

GameScenes.AnimalsToRetrieve = Scene_AnimalsToRetrieve;
module.exports = Scene_AnimalsToRetrieve;
