require('game/scenes/diary/Diary');
const Window_ExternalDiaryPageAnimation = require('../../windows/diary/ExternalDiaryPageAnimation');

class Scene_Settings extends GameScenes.Diary {
  initialize() {
    super.initialize(...arguments);

    Managers.Images.loadBackground('external_settings');
  }

  prepare(initialLayout = 'main') {
    super.prepare('settings');
  }

  changeDiaryPage(newPage = 'main') {
    super.changeDiaryPage('settings');
  }

  getLayoutImage() {
    return 'external_settings';
  }

  pageList() {
    return [
      'settings'
    ];
  }

  updateInput() {
  }

  updateTouchCheckTabIndexes(x, y) {
  }

  updatePageHandling() {
  }

  update() {
    if (this._changingPage) return;
    super.update();
  }

  createBackgroundContent() {
  }

  createBackground() {
  }

  updateDiarySprite() {
  }

  showSettingsWindows() {
    super.showSettingsWindows();
    this._bgAnimationWindow.show();
  }

  createSettingsContentWindow() {
    const layoutX = this._xOffset + 17 * this._zoomLevel;
    const layoutY = this._yOffset - 16 * this._zoomLevel;

    this._bgAnimationWindow = new Window_ExternalDiaryPageAnimation(0, 0, Graphics.width, Graphics.height, layoutX, layoutY, 'external_settings');
    this.addWindow(this._bgAnimationWindow);
    this._bgAnimationWindow.refresh();

    super.createSettingsContentWindow();
  }

  checkCloseButtonClick() {
    if (!TouchInput.isTriggered()) return false;

    const mouseX = TouchInput.mouseX;
    const mouseY = TouchInput.mouseY;

    const closeButtonX = this._bgAnimationWindow.x + (553 * Graphics.windowZoomLevel);
    if (mouseX < closeButtonX) return false;

    const closeButtonY = this._bgAnimationWindow.y + (49 * Graphics.windowZoomLevel);
    if (mouseY < closeButtonY) return false;

    const closeButtonW = 16 * Graphics.windowZoomLevel;
    if (mouseX > closeButtonX + closeButtonW) return false;

    const closeButtonH = 13 * Graphics.windowZoomLevel;
    if (mouseY > closeButtonY + closeButtonH) return false;

    return true;
  }
}

GameScenes.Settings = Scene_Settings;
module.exports = Scene_Settings;