const Scene_MenuBase = require('engine/scenes/Scene_MenuBase');
const Window_MapDisplay = require('../../windows/diary/MapDisplay');

class Scene_MapDisplay extends Scene_MenuBase {
  create() {
    super.create();

    this.createMapWindow();
  }

  createMapWindow() {
    this._mapDisplayWindow = new Window_MapDisplay(0, 0, Graphics.width, Graphics.height);
    this.addWindow(this._mapDisplayWindow);

    this._mapDisplayWindow.refresh();
  }

  update() {
    if (this.isCancelTriggered()) {
      this.popScene();
      return;
    }

    if (TouchInput.isTriggered() && this._mapDisplayWindow.isMouseOverExitButton()) {
      this.popScene();      
      return;
    }

    this._mapDisplayWindow.update();
  }

  isCancelTriggered() {
    if (Engine.Input.isRepeated('cancel')) return true;
    if (Engine.Input.isRepeated('alternate')) return true;
    if (Engine.Input.isRepeated('map')) return true;

    return false;
  }
}

GameScenes.MapDisplay = Scene_MapDisplay;
module.exports = Scene_MapDisplay;