require('game/scenes/diary/Diary');
const Window_ExternalDiaryPageAnimation = require('../../windows/diary/ExternalDiaryPageAnimation');
const Window_LoadContent = require('../../windows/diary/LoadContent');
const Window_DataDetailedContent = require('../../windows/diary/DataDetailedContent');

class Scene_LoadGame extends GameScenes.Diary {
  initialize() {
    super.initialize(...arguments);

    Managers.Images.loadBackground('external_load');
    Managers.Images.loadPicture('menu/orange_background');
    Managers.Images.loadPicture('menu/slot_1');
    Managers.Images.loadPicture('menu/slot_2');
    Managers.Images.loadPicture('menu/choices/choice_type_1');
    Managers.Images.loadPicture('menu/choices/ok');
    Managers.Images.loadPicture('menu/choices/ok_selected');
    Managers.Images.loadPicture('menu/choices/nop');
    Managers.Images.loadPicture('menu/choices/nop_selected');
    Managers.Images.loadPicture('menu/stamp_font');
  }

  terminate() {
    super.terminate();

    Managers.Images.releaseBackground('external_load');
    Managers.Images.releasePicture('menu/orange_background');
    Managers.Images.releasePicture('menu/slot_1');
    Managers.Images.releasePicture('menu/slot_2');
    Managers.Images.releasePicture('menu/choices/choice_type_1');
    Managers.Images.releasePicture('menu/choices/ok');
    Managers.Images.releasePicture('menu/choices/ok_selected');
    Managers.Images.releasePicture('menu/choices/nop');
    Managers.Images.releasePicture('menu/choices/nop_selected');
    Managers.Images.releasePicture('menu/stamp_font');
  }

  prepare(initialLayout = 'main') {
    super.prepare('data');
  }

  changeDiaryPage(newPage = 'main') {
    super.changeDiaryPage('data');
  }

  updateInput() {
  }

  getLayoutImage() {
    return 'external_load';
  }

  pageList() {
    return [
      'data'
    ];
  }

  updateTouchCheckTabIndexes(x, y) {
  }

  updatePageHandling() {
  }

  showDataWindows() {
    super.showDataWindows();
    this._bgAnimationWindow.show();
  }

  update() {
    if (this._changingPage) return;
    super.update();
  }

  createDataContentWindow() {
    const layoutX = this._xOffset + 17 * this._zoomLevel;
    const layoutY = this._yOffset - 16 * this._zoomLevel;

    this._bgAnimationWindow = new Window_ExternalDiaryPageAnimation(0, 0, Graphics.width, Graphics.height, layoutX, layoutY, 'external_load');
    this.addWindow(this._bgAnimationWindow);

    this._bgAnimationWindow.refresh();

    const x = this._xOffset + 32 * this._zoomLevel;
    const y = 36 * this._zoomLevel + this._yOffset;

    const height = this._pageHeight + 14 * this._zoomLevel;

    this._dataContentWindow = new Window_LoadContent(x, y, this._pageWidth + 43 * this._zoomLevel, height);
    this.addWindow(this._dataContentWindow);

    this._dataContentWindow.setEmptyListAction('popScene');
    this._dataContentWindow.setErrorCallback(this.onLoadFailure.bind(this));

    const page2X = x + (17 * this._zoomLevel) + this._pageWidth + this._pageSeparator;
    this._dataDetailedContentWindow = new Window_DataDetailedContent(page2X, y, this._pageWidth, height);
    this.addWindow(this._dataDetailedContentWindow);
  }

  onLoadFailure(e) {
    if (e && e instanceof Utils.UpdateError) {
      if (e.versionNumber) {
        this.showAlert(t("Failed to update your game file to version <versionNumber>").replace('<versionNumber>', e.versionNumberStr()), 120);
      } else {
        this.showAlert(t("Failed to load your game file."), 120);
      }
    }

    Managers.Sound.playBuzzer();
  }

  createBackgroundContent() {
  }

  createBackground() {
  }

  updateDiarySprite() {
  }

  checkCloseButtonClick() {
    if (!TouchInput.isTriggered()) return false;

    const mouseX = TouchInput.mouseX;
    const mouseY = TouchInput.mouseY;

    const closeButtonX = this._bgAnimationWindow.x + (553 * Graphics.windowZoomLevel);
    if (mouseX < closeButtonX) return false;

    const closeButtonY = this._bgAnimationWindow.y + (49 * Graphics.windowZoomLevel);
    if (mouseY < closeButtonY) return false;

    const closeButtonW = 16 * Graphics.windowZoomLevel;
    if (mouseX > closeButtonX + closeButtonW) return false;

    const closeButtonH = 16 * Graphics.windowZoomLevel;
    if (mouseY > closeButtonY + closeButtonH) return false;

    return true;
  }
}

GameScenes.LoadGame = Scene_LoadGame;
module.exports = Scene_LoadGame;