const Scene_MenuBase = require('engine/scenes/Scene_MenuBase');
const Window_RecipesBackground = require('../../windows/crafts/RecipesBackground');
const Window_RecipeList = require('../../windows/crafts/RecipeList');
const Window_RecipeItemInfo = require('../../windows/crafts/RecipeItemInfo');

class Scene_RecipeList extends Scene_MenuBase {
  initialize() {
    super.initialize(...arguments);
    this._zoomLevel = Graphics.windowZoomLevel;
  }

  create() {
    super.create();

    const realWidth = 470 * this._zoomLevel;
    const realHeight = 265 * this._zoomLevel;
    const x = (Graphics.width - realWidth) / 2;
    const y = (Graphics.height - realHeight) / 2;

    this._xOffset = x;
    this._yOffset = y;

    this.createBackgroundContent();
    this.createListWindow();
    this.createInfoWindow();
    this.createCloseButton();
  }

  createListWindow() {
    const x = 0 * this._zoomLevel;
    const y = 17 * this._zoomLevel;
    const w = 300 * this._zoomLevel;
    const h = 250 * this._zoomLevel;

    this._listWindow = new Window_RecipeList(this._xOffset + x, this._yOffset + y, w, h);
    this.addWindow(this._listWindow);

    this._listWindow.setHandler('ok', this.onSelectRecipe.bind(this));
  }

  createBackgroundContent() {
    const x = 0;
    const y = 0;
    const w = Graphics.width;
    const h = Graphics.height;

    this._bgContentWindow = new Window_RecipesBackground(x, y, w, h, this._xOffset, this._yOffset);
    this.addWindow(this._bgContentWindow);

    this._bgContentWindow.refresh();
  }

  createInfoWindow() {
    const x = 292 * this._zoomLevel;
    const y = 20 * this._zoomLevel;
    const w = 165 * this._zoomLevel;
    const h = 240 * this._zoomLevel;

    this._infoWindow = new Window_RecipeItemInfo(this._xOffset + x, this._yOffset + y, w, h);
    this.addWindow(this._infoWindow);

    this._listWindow.setInfoWindow(this._infoWindow);
  }

  createCloseButton() {
    const button = new Sprite_Button();
    button.bitmap = Managers.Images.loadSystem('CloseButton');

    const w = 48;
    const h = 48;

    button.setColdFrame(0, 0, w, h);
    button.setHotFrame(0, h, w, h);
    
    this.addChild(button);

    button.setClickHandler(this.popScene.bind(this));

    button.x = this._xOffset + 440 * Graphics.windowZoomLevel;
    button.y = this._yOffset + 16 * Graphics.windowZoomLevel;
  }

  isCancelTriggered() {
    if (Engine.Input.isRepeated('cancel')) return true;
    if (Engine.Input.isRepeated('alternate')) {
      return true;
    }

    return false;
  }

  onSelectRecipe() {
    const recipe = this._listWindow.selectedRecipe();
    if (recipe) {
      Managers.Scenes.push(GameScenes.Cooking);
      Managers.Scenes.prepareNextScene(recipe);
      return;
    }

    this._listWindow.activate();
  }

  update() {
    super.update();

    if (this.isCancelTriggered()) {
      this.popScene();
      return;
    }
  }
}

GameScenes.Recipes = Scene_RecipeList;
module.exports = Scene_RecipeList;