const Scene_InputBase = require('./Scene_InputBase');
const Window_StringEdit = require('../windows/Window_StringEdit');

//-----------------------------------------------------------------------------
// Scene_StringVariable
//
// The scene class to input a string variable
class Scene_StringVariable extends Scene_InputBase {
  prepare(variableName, maxLength) {
    this._variableName = variableName;
    this._maxLength = maxLength;
  }

  applyInputedName() {
    Variables[this._variableName] = this._editWindow.name();
    this.popScene();
  }

  createEditWindow() {
    this._editWindow = new Window_StringEdit(Variables[this._variableName], this._maxLength);
    this.addWindow(this._editWindow);
  }
}

GameScenes.StringVariable = Scene_StringVariable;
module.exports = Scene_StringVariable;
