const Scene_MenuBase = require('engine/scenes/Scene_MenuBase');
const FreeContent = require('engine/windows/FreeContent');

//-----------------------------------------------------------------------------
// Scene_PreloadSave
//
// The scene class used to show a loading screen while applying character customization
class Scene_PreloadSave extends Scene_MenuBase {
  initialize() {
    super.initialize();
    this._autoLoad = true;
    this._changedTip = false;
  }

  create() {
    this.barHeadTime = 0;
    this.barHeadFrame = 0;
    this.screenRatio = this.measureScreenRatio();
    this.createSceneBackground();
    super.create();
    if (this._autoLoad) {
      this.createLoadingContent();
    }
  }

  createLoadingContent() {
    this.progress = 0;
    this.createLogo();
    this.createTip();
    Managers.Player.clearPreloadData();
  }

  start() {
    super.start();
    this.preloadSprites();
  }

  preloadSprites() {
    var name = Managers.Player.generatePlayerSpriteName();
    Managers.Player.preloadSprites(name);
  }

  isReady() {
    return true;
  }

  createBackground() {
  }

  createSceneBackground() {
    this._background = new Sprite(Managers.Images.loadPicture('loading_bg_image'));
    this._background.scale.x = this._background.scale.y = this.screenRatio;
    this._background.x = this.backgroundX();
    this.backgroundMask = new Sprite(Managers.Images.loadPicture('loading_bg_mask'));
    this.backgroundMask.scale.x = Graphics.width / 500;
    this.backgroundMask.scale.y = Graphics.height / 500;
    this.addChild(this._background);
    this.addChild(this.backgroundMask);
  }

  createLogo() {
    var logoWidth = 184 * this.screenRatio;
    this.logo = new Sprite(Managers.Images.loadPicture('loading_logo'));
    this.logo.scale.x = this.logo.scale.y = this.screenRatio * 3;
    this.logo.x = Math.floor((Graphics.width - logoWidth * 3) / 2);
    this.logo.y = 24 * Graphics.windowZoomLevel;
    this.addChild(this.logo);
  }

  createTip() {
    const text = Managers.Text.getRandomTip();
    this.tip = new FreeContent(50, Graphics.height - 35 * Graphics.windowZoomLevel, Graphics.width - 100, 2);
    this.tip.contents.fontSize = Utils.convertFontSize(30, Graphics.windowZoomLevel);
    this.tip.contents.textColor = this.tip.blackColor();
    this.tip.contents.outlineWidth = 0;
    this.tip.quickText(text, 'center');
    this.addChild(this.tip);
  }

  updateLoading() {
    if (this._complete) {
      return;
    }

    if (this.progress < 1000) {
      this.progress = Managers.Player.getPreloadProgress();
    } else {
      this._complete = true;
      const scene = this;
      setTimeout(function () {
        scene.continueGameStart();
      }, 100);
    }
  }

  update() {
    super.update();
    this.updateLoading();
  }

  continueGameStart() {
    if (Utils._isTestMode && window.quickDiary) {
      Managers.Scenes.goToScene(GameScenes.Diary);
    }
    else {
      Managers.Scenes.goToScene(GameScenes.GameMap);
    }
  }
}

GameScenes.PreloadSave = Scene_PreloadSave;
module.exports = Scene_PreloadSave;