const Scene_Base = require('engine/scenes/Scene_Base');
//-----------------------------------------------------------------------------
// Scene_NewGame
//
// This scenes starts a new game
class Scene_NewGame extends Scene_Base {
  initialize() {
    super.initialize();
    this._canStart = true;
  }

  start() {
    super.start();
    Engine.Audio.playBgmName('title');
  }

  update() {
    super.update();
    if (this._canStart) {
      Engine.Data.setupNewGame();
      this.fadeOutAll();
      Managers.Player.createRandomCharacter();
      Managers.Scenes.goToScene(GameScenes.CreateCharacter);
      this._canStart = false;
    }
  }

  createBackground() {
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = Managers.Scenes.backgroundBitmap();
    this.addChild(this._backgroundSprite);
  }

  setBackgroundOpacity(opacity) {
    this._backgroundSprite.opacity = opacity;
  }

  mustFadeOutBgm() {
    return false;
  }
}

GameScenes.NewGame = Scene_NewGame;
module.exports = Scene_NewGame;
