const Scene_InputBase = require('./Scene_InputBase');
const Window_NameEdit = require('../windows/Window_NameEdit');
//-----------------------------------------------------------------------------
// Scene_Name
//
// The scene class of the name input screen.
class Scene_Name extends Scene_InputBase {
  prepare(actorId, maxLength) {
    this._actorId = actorId;
    this._maxLength = maxLength;
  }

  create() {
    this._actor = $gameActors.actor(this._actorId);
    super.create();
  }

  applyInputedName() {
    this._actor.setName(this._editWindow.name());
    this.popScene();
  }

  createEditWindow() {
    this._editWindow = new Window_NameEdit(this._actor, this._maxLength);
    this.addWindow(this._editWindow);
  }
}

GameScenes.Name = Scene_Name;
module.exports = Scene_Name;