const Scene_MoveItem = require('./Scene_MoveItem');
const Window_ModernItemContainer = require('../windows/containers/ModernItemContainer');
const Window_MailboxItemContainer = require('../windows/containers/MailboxItemContainer');
const Window_ContainerBackground = require('../windows/containers/ContainerBackground');
const Window_ContainerSummary = require('../windows/containers/ContainerSummary');

//-----------------------------------------------------------------------------
// Scene_Mailbox
//
// The scene class of the mailbox screen.
class Scene_Mailbox extends Scene_MoveItem{
  create() {
    this._zoomLevel = Graphics.windowZoomLevel;
    this._contentWidth = 351 * this._zoomLevel;
    this._contentHeight = 193 * this._zoomLevel;
    this._offsetX = (Graphics.width - this._contentWidth) / 2;
    this._offsetY = (Graphics.height - this._contentHeight) / 2;

    super.create();
    this.createSummaryWindow();
    this.updateTotal();

    this._leftWindow.select(0);
    this._leftWindow.activate();
  }

  createBackgroundImageWindow() {
    this._bgWindow = new Window_ContainerBackground(0, 0, Graphics.width, Graphics.height, this._offsetX, this._offsetY, 'mailbox_layout');
    this.addWindow(this._bgWindow);

    this._bgWindow.refresh();
  }

  createLeftWindow() {
    const x = this._offsetX + (38 * this._zoomLevel);
    const y = this._offsetY + (30 * this._zoomLevel);
    const width = 280 * this._zoomLevel;
    const height = 84 * this._zoomLevel;

    const maxItems = 20;

    this._leftWindow = new Window_MailboxItemContainer(x, y, width, height, Managers.Items.mailboxContainer, maxItems);
    this.addWindow(this._leftWindow);
    this._leftWindow._checkInput = false;
    this._leftWindow._allowTouchWhenInactive = true;
    this._leftWindow.margin = 0;
    this._leftWindow.refresh();

    this._leftWindow.setHandler('updateHelp', this.updateTotal.bind(this));
    this._leftWindow.setHandler('beforeSelectByTouch', this.touchOnLeftItem.bind(this));
  }

  createRightWindow() {
    const x = -10;
    const y = -10;
    const maxItems = Managers.Items.maxItemTypes();

    this._rightWindow = new Window_ModernItemContainer(x, y, 1, 1, Managers.Items.container, maxItems);
    this.addWindow(this._rightWindow);
    this._rightWindow._checkInput = false;
    this._rightWindow._allowTouchWhenInactive = false;
    this._rightWindow.margin = 0;
    this._rightWindow.refresh();
    this._rightWindow.hide();
    this._rightWindow.deactivate();
  }

  touchOnLeftItem() {
  }

  touchOnRightItem() {
  }
  
  createSummaryWindow() {
    const width = 343 * this._zoomLevel;
    const height = 68 * this._zoomLevel;
    const y = this._offsetY + (125 * this._zoomLevel);
    const x = (Graphics.width - width) / 2;

    this._summaryWindow = new Window_ContainerSummary(x, y, width, height);
    this.addWindow(this._summaryWindow);

    this._summaryWindow.refresh();
  }

  moveToLeftWindow(all, item, usedKeyboard) {
    // Nothing to do here, you can't put items on the mailbox
  }

  moveToRightWindow(all, item) {
    if (!item) {
      return;
    }

    // #ToDo: read letters here

    Managers.Items.mailboxContainer.moveItem(item, Managers.Items.container, all ? item.amount : 1);
    this._inputDelay = Utils.getFrameCount(10);
    this._needsRefresh = true;
  }

  updateTotal() {
    const leftItem = this._leftWindow.item();

    if (leftItem) {
      const itemName = Managers.Text.item(leftItem.id);
      let text = itemName;

      if (itemName && leftItem.amount > 1) {
        text = `${ itemName } x ${ leftItem.amount }`;
      }

      if (text) {
        this._summaryWindow.setText(text);
        return;
      }
    }

    this._summaryWindow.setText('');
  }

  clampIndex(index, theWindow) {
    if (theWindow === undefined) {
      theWindow = this._leftWindow;
    }
    
    const maxItems = theWindow.maxItems();
    return index.clamp(0, maxItems - 1);
  }

  update() {
    super.update();

    if (TouchInput.isTriggered() && this._bgWindow.isMouseOverCloseButton()) {
      this.onClickClose();
    }
  }

  canMoveCursor() {
    return true;
  }

  updateInput() {
    if (this._inputDelay > 0) {
      this._inputDelay--;
      return;
    }

    const oldIndex = this._leftWindow.index();

    if (Engine.Input.isPressed('down')) {
      this._leftWindow.cursorDown(Engine.Input.isTriggered('down'));
    } else if (Engine.Input.isPressed('up')) {
      this._leftWindow.cursorUp(Engine.Input.isTriggered('up'));
    } else if (Engine.Input.isPressed('right')) {
      this._leftWindow.cursorRight(Engine.Input.isTriggered('right'));
    } else if (Engine.Input.isPressed('left')) {
      this._leftWindow.cursorLeft(Engine.Input.isTriggered('left'));
    } else if (Engine.Input.isPressed('ok') || Engine.Input.isPressed('extra') ) {
      this.moveCurrentItem(true, true);
    }

    if (oldIndex != this._leftWindow.index()) {
      this._inputDelay = Utils.getFrameCount(8);
      this._needsRefresh = true;
      Managers.Sound.playCursor();
    }
  }

  refresh() {
    super.refresh();
    this.updateTotal();
  }
}

GameScenes.Mailbox = Scene_Mailbox;
module.exports = Scene_Mailbox;