const Scene_MenuBase = require('engine/scenes/Scene_MenuBase');
const Window_NameInput = require('../windows/Window_NameInput');
//-----------------------------------------------------------------------------
// Scene_InputBase
//
// The scene class of the animal name input screen.
class Scene_InputBase extends Scene_MenuBase {
  initialize() {
    super.initialize();
    this._readingInputString = false;
  }

  create() {
    super.create();
    this.createEditWindow();
    this.createInputWindow();
    this._inputWindow.hide();
    this._inputWindow.deactivate();
    this._readingInputString = false;

    if (Engine.Input.gamepadActivated) {
      this._inputType = 'gamepad';
    } else {
      this._inputType = 'keyboard';
    }
  }

  start() {
    super.start();
    this._editWindow.refresh();
    this.activateInputWindow();
  }

  activateInputWindow() {
    if (this._inputType == 'gamepad') {
      this.activateVirtualKeyboard();
    } else {
      this.activateComputerKeyboard();
    }
  }

  activateComputerKeyboard() {
    this._readingInputString = true;

    const inputField = document.getElementById('inputField');
    inputField.style.display = 'block';
    inputField.value = this._editWindow._name;
    inputField.focus();

    this._readStringDelay = Utils.getFrameCount(10);
  }

  onConfirmName() {
    const newName = this._editWindow.name();

    if (!newName) {
      Managers.Sound.playBuzzer();
      this.activateInputWindow();
      return;
    }

    this.applyInputedName(newName);
  }

  applyInputedName(name) {
    Managers.Scenes.popTo(GameScenes.GameMap);
  }

  update() {
    Scene_MenuBase.prototype.update.call(this);
    if (this._readingInputString) {
      if (this._readStringDelay) {
        this._readStringDelay--;
        return;
      }
      this.readInputString();
    }
  }

  readInputString() {
    const inputField = document.getElementById('inputField');
    if (inputField != document.activeElement) {
      inputField.focus();
    }

    const newName = inputField.value;
    const oldName = this._editWindow.name();
    this._editWindow.setName(newName);
    const appliedName = this._editWindow.name();

    if (newName != appliedName) {
      inputField.value = appliedName;
    }

    if (oldName != appliedName) {
      this._editWindow.refresh();
    }
    else {
      this._editWindow.refreshCursor();
    }

    if (Engine.Input.isCodePressed(13) || Engine.Input.isCodePressed(27)) {
      this._readingInputString = false;
      inputField.style.display = 'none';

      this.onConfirmName();
    }
  }

  activateVirtualKeyboard() {
    this._inputWindow.show();
    this._inputWindow.activate();
  }

  createEditWindow() {
    // You need an editWindow
  }

  createInputWindow() {
    this._inputWindow = new Window_NameInput(this._editWindow);
    this._inputWindow.setHandler('ok', this.onInputOk.bind(this));
    this.addWindow(this._inputWindow);
  }

  onInputOk() {
    this._inputWindow.hide();
    this._inputWindow.deactivate();

    this.onConfirmName();
  }
}

module.exports = Scene_InputBase;