const Scene_PreloadSave = require('./Scene_PreloadSave');
const Window_CreateCharacter = require('../windows/Window_CreateCharacter');
const Window_Warning = require('../windows/core/Warning');

//-----------------------------------------------------------------------------
// Scene_CreateCharacter
//
// The scene class of the character creation screen.
class Scene_CreateCharacter extends Scene_PreloadSave {
  initialize() {
    super.initialize();
    this._autoLoad = false;
  }

  create() {
    super.create();
    this.createCharacterWindow();
    this.createCloseButton();
  }

  start() {
    super.start();
    Engine.Audio.playBgmName('title');
  }

  preloadSprites() {
  }

  createCharacterWindow() {
    this._creationWindow = new Window_CreateCharacter();
    this._creationWindow.setHandler('cancel', this.cancel.bind(this));
    this._creationWindow.setHandler('startGame', this.startGame.bind(this));
    this._creationWindow.setHandler('returnToGame', this.returnToGame.bind(this));
    this._creationWindow.setHandler('inputName', this.inputName.bind(this));
    this._creationWindow.setHandler('inputPetName', this.inputPetName.bind(this));
    this._creationWindow.setHandler('inputFarmName', this.inputFarmName.bind(this));
    this.addWindow(this._creationWindow);

    this._creationWindow.refresh();
  }

  createCloseButton() {
    const button = new Sprite_Button();
    button.bitmap = Managers.Images.loadSystem('CloseButton');

    const w = 48;
    const h = 48;

    button.setColdFrame(0, 0, w, h);
    button.setHotFrame(0, h, w, h);
    
    this._creationWindow.addChild(button);
    this._creationWindowCloseButton = button;

    button.setClickHandler(this.cancel.bind(this));

    button.x = 284 * Graphics.windowZoomLevel;
    button.y = 12 * Graphics.windowZoomLevel;
  }

  updateLoading() {
    if (this._showLoading) {
      super.updateLoading();
    }
  }


  continueGameStart() {
    if (this._closeScene) {
      Managers.Scenes.pop();
      return;
    }

    if (Managers.Player._quickStart) {
      $gameTemp.enableQuickStart();
    } else {
      $gameTemp.disableQuickStart();
    }

    Managers.Scenes.goToScene(GameScenes.GameMap);
  }

  validateData() {
    const farmName = (Variables.farmName || '').trim();
    const petName = (Variables.dogName || '').trim();
    const playerName = Managers.Player.getName().trim();

    if (!playerName) {
      this.showAlert(t("Tell us your <color:important>name</color>."));
      return false;
    }

    if (!farmName) {
      this.showAlert(t("Give your <color:important>Farm</color> a name."));
      return false;
    }

    if (!petName) {
      this.showAlert(t("Give your <color:important>Pet</color> a name."));
      return false;
    }

    return true;
  }

  startGame() {
    if (!this.validateData()) {
      return;
    }

    this._creationWindow.hide();
    this._creationWindow.deactivate();
    this._showLoading = true;

    Managers.Player.changeActorData(false);
    this.createLoadingContent();

    const name = Managers.Player.generatePlayerSpriteName();
    Managers.Player.preloadSprites(name);

    $gameTemp.setLoadedGamePath(null);
  }

  returnToGame() {
    this._creationWindow.hide();
    this._creationWindow.deactivate();
    this._showLoading = true;
    this._closeScene = true;
    Managers.Player.changeActorData(false);
    this.createLoadingContent();
    var name = Managers.Player.generatePlayerSpriteName();
    Managers.Player.preloadSprites(name);
  }

  cancel() {
    if ($gameTemp._initialName) {
      $gamePlayer.actor().setName($gameTemp._initialName);
    }

    if ($gameTemp._initialData) {
      Managers.Player.setData($gameTemp._initialData, $gamePlayer);
      Managers.Player.changeActorData(false);
    }

    Managers.Scenes.pop();
  }

  inputName() {
    Managers.Scenes.push(GameScenes.Name);
    Managers.Scenes.prepareNextScene(1, 20);
  }

  inputPetName() {
    Managers.Scenes.push(GameScenes.StringVariable);
    Managers.Scenes.prepareNextScene('dogName', 20);
  }

  inputFarmName() {
    Managers.Scenes.push(GameScenes.StringVariable);
    Managers.Scenes.prepareNextScene('farmName', 20);
  }

  showAlert(text) {
    if (this._alertWindow) {
      // Move it to the top
      this.addWindow(this._alertWindow);
    } else {
      this._alertWindow = new Window_Warning();
      this.addWindow(this._alertWindow);
    }

    this._alertWindow.setText(text);
    this._alertWindow.visible = true;
    this._creationWindow.deactivate();
    this._delay = Utils.getFrameCount(30);
  }

  update() {
    super.update();

    if (this._alertWindow && this._alertWindow.visible) {
      if (this._delay > 0) {
        this._delay--;
      } else if (TouchInput.isTriggered() || Engine.Input.isTriggered('ok')) {
        this.hideAlert();
      }

      return;
    }
  }

  hideAlert() {
    this._alertWindow.hide();
    $gameTemp.skipSelectableWindowHandling(true);
    setTimeout(() => {
      this._creationWindow.activate();
    }, 200);
  }
}

GameScenes.CreateCharacter = Scene_CreateCharacter;
module.exports = Scene_CreateCharacter;