const Scene_Base = require('engine/scenes/Scene_Base');
//-----------------------------------------------------------------------------
// Scene_AutoLoad
//
// This scenes execute an auto load and redirects to the map scene
class Scene_AutoLoad extends Scene_Base {
  create() {
    super.create();
    this.createBackground();
  }

  prepare(slotName) {
    this._slotName = slotName;
  }

  update() {
    super.update();
    if (this._slotName) {
      Engine.Data._executeAutoLoad(this._slotName);
      this._slotName = undefined;
    }
  }

  createBackground() {
    this._backgroundSprite = new Sprite();
    this._backgroundSprite.bitmap = Managers.Scenes.backgroundBitmap();
    this.addChild(this._backgroundSprite);
  }

  setBackgroundOpacity(opacity) {
    this._backgroundSprite.opacity = opacity;
  }

  isBusy() {
    return false;
  }
}

GameScenes.AutoLoad = Scene_AutoLoad;
module.exports = Scene_AutoLoad;