const Scene_InputBase = require('./Scene_InputBase');
//-----------------------------------------------------------------------------
// Scene_AnimalName
//
// The scene class of the animal name input screen.
class Scene_AnimalName extends Scene_InputBase {
  prepare(currentName, creatureData) {
    this._currentName = currentName;
    this._creatureData = creatureData;
  }

  applyInputedName(name) {
    Managers.Creatures.applyInputedName(name);
    Managers.Scenes.popTo(GameScenes.GameMap);
  }

  createEditWindow() {
    const Window_AnimalNameEdit = require('game/windows/Window_AnimalNameEdit');

    this._editWindow = new Window_AnimalNameEdit();
    this._editWindow.setName(this._currentName);
    this._editWindow.setCreatureData(this._creatureData);
    this.addWindow(this._editWindow);
  }
}

GameScenes.AnimalName = Scene_AnimalName;
module.exports = Scene_AnimalName;