const Scene_Map = require('engine/scenes/Scene_Map');

class GameMap extends Scene_Map {
  initialize() {
    super.initialize(arguments);
    this._finishedPreloadingFiles = false;
    Managers.Preload.preloadFiles(() => {
      this._finishedPreloadingFiles = true;
    }, 'game');
  }

  isReady() {
    if (!this._finishedPreloadingFiles) {
      return false;
    }

    return super.isReady();
  }

  updateTransferPlayer() {
    if ($gamePlayer.isTransferring()) {
      Managers.Scenes.goToScene(GameMap);
    }
  }
}

GameScenes.GameMap = GameMap;
module.exports = GameMap;