/*:
 * @plugindesc This plugin sets the game into demo mode
 * @author Hudell
 */

const Scene_Map = require('engine/scenes/Scene_Map');
require('game/managers/Time');
require('engine/objects/Temp');

const oldCanCloseDateChangeWindow = Objects.Temp.prototype.canCloseDateChangeWindow;
const oldGetDateDescription = Managers.Time.getDateDescription;
const oldUpdateSleep = Scene_Map.prototype.updateSleep;

OrangeSeason.Plugins.Demo = class Demo {
  static activate() {
    Objects.Temp.prototype.canCloseDateChangeWindow = OrangeSeason.Plugins.Demo.canCloseDateChangeWindow;
    Managers.Time.getDateDescription = OrangeSeason.Plugins.Demo.getDateDescription;
    Scene_Map.prototype.updateSleep = OrangeSeason.Plugins.Demo.updateSleep;
  }

  static canCloseDateChangeWindow() {
    if (Managers.Time.month > 1) return false;
    if (Managers.Time.year > 1) return false;
    if (Managers.Scenes.isSceneChanging()) return false;

    return oldCanCloseDateChangeWindow.call($gameTemp);
  }

  static getDateDescription(dateTime) {
    if (dateTime === undefined) {
      dateTime = Managers.Time.getDateTime();
    }

    if (dateTime) {
      if (dateTime.month > 1 || dateTime.year > 1) {
        return t('Thank you for playing this demo.');
      }
    }

    return oldGetDateDescription.call(Managers.Time, dateTime);
  }

  //This is called on the context of the Scene_Map instance
  static updateSleep() {
    oldUpdateSleep.call(this);

    if (Managers.Time.month > 1 || Managers.Time.year > 1) {
      if (this._dateChangeWindow && this._dateChangeWindow._isDone) {
        if (Engine.Input.isTriggered('ok')) {
          this._dateChangeWindow.hide();

          Managers.Scenes.goToScene(GameScenes.Title);
          return;
        }
      }
    }
  }
};