require('../Object');

Objects.AnimatedObject = class AnimatedObject extends Objects.Object {
  initialAnimationTimeout() {
    return Utils.getFrameCount(10);
  }

  startEventAnimation() {
    this._animationTimeout = this.initialAnimationTimeout();
  }

  updateEventAnimation() {
    this._lockPattern = true;

    if (this._animationTimeout === undefined) {
      this.startEventAnimation();
      return;
    }

    if (!this._animationTimeout) {
      this.nextAnimationFrame();
      return;
    }

    this._animationTimeout--;
  }

  allAnimationFrames() {
    return [
    ];
  }

  shouldStopAnimation() {
    return false;
  }

  nextAnimationFrame() {
    const allFrames = this.allAnimationFrames();

    let currentFrame = this._currentFrame || 0;

    let nextFrame = currentFrame + 1;
    if (nextFrame >= allFrames.length) {
      nextFrame = 0;
    }

    this._currentFrame = nextFrame;
    const frameData = allFrames[nextFrame];

    if ('index' in frameData) {
      this._characterIndex = frameData.index;
    }

    if ('direction' in frameData) {
      this._direction = frameData.direction;
    }

    if ('pattern' in frameData) {
      this._pattern = frameData.pattern;
    }

    if (this._currentFrame === 0 && this.shouldStopAnimation()) {
      this._animationTimeout = undefined;
      return;
    }

    this._animationTimeout = Utils.getFrameCount(frameData.frameLength);
  }

  isStaticPosition() {
    return false;
  }

  getSpriteClass() {
    return Sprites.AnimatedObject;
  }
};