require('../CustomEvent');

Objects.AnimatedEvent = class AnimatedEvent extends Objects.CustomEvent {
  update() {
    super.update();
    this.updateEventAnimation();
  }

  initialAnimationTimeout() {
    return Utils.getFrameCount(10);
  }

  updateEventAnimation() {
    this._lockPattern = true;

    if (this._animationTimeout === undefined) {
      this._animationTimeout = this.initialAnimationTimeout();
      return;
    }

    if (!this._animationTimeout) {
      this.nextAnimationFrame();
      return;
    }

    this._animationTimeout--;
  }

  allAnimationFrames() {
    return [
    ];
  }

  nextAnimationFrame() {
    const allFrames = this.allAnimationFrames();

    let currentFrame = this._currentFrame || 0;

    let nextFrame = currentFrame + 1;
    if (nextFrame >= allFrames.length) {
      nextFrame = 0;
    }

    this._currentFrame = nextFrame;
    const frameData = allFrames[nextFrame];

    if ('index' in frameData) {
      this._characterIndex = frameData.index;
    }

    if ('direction' in frameData) {
      this._direction = frameData.direction;
    }

    if ('pattern' in frameData) {
      this._pattern = frameData.pattern;
    }


    this._animationTimeout = Utils.getFrameCount(frameData.frameLength);
  }
};