//-----------------------------------------------------------------------------
// Objects.WildCreature
//
// The game object class for animals that don't belong to the player

Objects.WildCreature = class WildCreature extends Objects.Creature {
  hasAnythingToRun(activatedByMouse = false) {
    return false;
  }

  setEventTypeData() {
    this._moveType = 1;
    this._moveFrequency = 5;
  }

  start(activatedByMouse = false) {
    return false;
  }

  moveTypeRandom() {
    switch (Math.randomInt(10)) {
      case 0:
        this.moveRandom();
        break;
      case 1:
        this.moveForward();
        break;
      default :
        this.stopForAWhile(Math.randomInt(60));
        break;
    }
  }
};
