//-----------------------------------------------------------------------------
// Game_StoreSwitchObject
//
// The game object class for Store switch sale events

Objects.StoreSwitchObject = class StoreSwitchObject extends Objects.CustomEvent {
  get switchId() {
    return this._switchId;
  }

  set switchId(value) {
    this._switchId = value;
  }

  initialize() {
    super.initialize(...arguments);
    this._switchId = 0;
  }

  hasAnythingToRun(activatedByMouse = false) {
    return true;
  }

  start(activatedByMouse = false) {
    Managers.Shop.prepareShopForSwitch(this.switchId);
    Managers.CommonEvent.playEvent('store_buy_switch');
    
    return true;
  }

  maxActivationDistance() {
    return Constants.MAX_EVENT_DISTANCE_MOUSE_OVER * 2;
  }
};
