//-----------------------------------------------------------------------------
// Game_StoreObject
//
// The game object class for Store sale events

Objects.StoreObject = class StoreObject extends Objects.CustomEvent {
  get itemId() {
    return this._itemId;
  }
  set itemId(value) {
    this._itemId = value;
  }

  initialize() {
    super.initialize(...arguments);
    this._itemId = '';
  }

  hasAnythingToRun(activatedByMouse = false) {
    return !Managers.Items.isHoldingItem();
  }

  start(activatedByMouse = false) {
    if (Managers.Items.isHoldingItem()) return false;

    Switches.bagWasFullWhileBuying = false;
    Managers.Shop.openShopSceneForItem(this.itemId);
    return true;
  }

  maxActivationDistance() {
    return Constants.MAX_EVENT_DISTANCE_MOUSE_OVER * 2;
  }
};