require('./Animal');

//-----------------------------------------------------------------------------
// Objects.SmallAnimal
//
// The game object class for small animal events

Objects.SmallAnimal = class SmallAnimal extends Objects.Animal {
  constructor() {
    super(...arguments);
    this._moveType = 1;
  }

  initMembers() {
    super.initMembers();
  }

  restoreSpeed() {
    this._moveSpeed = 1;
  }

  isWildAnimal() {
    if (!this._creatureData) return false;

    return !this._creatureData._creatureName;
  }

  hasAnythingToRun(activatedByMouse = false) {
    if ($gamePlayer.isRiding()) return false;

    return super.hasAnythingToRun(activatedByMouse);
  }

  start(activatedByMouse = false) {
    if (!this._creatureData) return false;

    if (this.checkGifts()) {
      return true;
    }

    if ($gamePlayer.isRiding()) return false;

    // If the animal has no name (it's a wild animal), then you need friendship before you can pick it up
    if (this.isWildAnimal()) {
      const friendship = this._creatureData.friendship || 0;
      Variables.animalFriendship = friendship;

      if (friendship < this.minFriendship()) {
        return this.doWildAnimalReaction();
      }

      return this.doWildAnimalNaming();
    }

    if (Managers.Items._specialItem) return false;
    if (Managers.Items.isHoldingItem()) return false;

    if (activatedByMouse && !TouchInput.isTriggered()) return false;

    this.chat();
    return true;
  }

  chat() {
    this.doAnimalDropReaction();
  }

  minFriendship() {
    return Managers.Relationship.getFriendshipLevels()[1];
  }

  doWildAnimalReaction() {
    this.doAnimalDropReaction();
  }

  doWildAnimalNaming() {

  }

  doAnimalDropReaction() {
    if (this._creatureData) {
      if (this._creatureData.spokenTo) {
        this.requestBalloon(Balloons.MUSIC);
      } else {
        this.requestBalloon(Balloons.HEART);
      }

      this._creatureData.spokenTo = true;
    }

    this.playAnimalSound();
  }

  setCreatureData(creatureData) {
    super.setCreatureData(...arguments);
    this._animalType = creatureData._type;
    // this._letPlayerWalkThroughThisEvent = true;
  }

  moveRandom() {
    const availableDirections = [];
    if (this._direction !== Direction.UP) {
      availableDirections.push(Direction.DOWN);
    }

    if (this._direction !== Direction.LEFT) {
      availableDirections.push(Direction.RIGHT);
    }

    if (this._direction !== Direction.RIGHT) {
      availableDirections.push(Direction.LEFT);
    }

    if (this._direction !== Direction.DOWN) {
      availableDirections.push(Direction.UP);
    }

    availableDirections.push(this._direction);
    availableDirections.push(this._direction);
    availableDirections.push(this._direction);

    const idx = Math.randomInt(availableDirections.length);

    const d = availableDirections[idx];
    if (this.canPass(this.x, this.y, d)) {
      this.moveStraight(d);
    }
  }

  moveTypeRandom() {
    switch (Math.randomInt(6)) {
      case 0:
      case 1:
        this.moveRandom();
        break;
      case 2:
        this.stopForAWhile(Math.randomInt(600));
        break;
      default :
        this.moveForward();
        break;
    }
  }

  //Don't let small animals get near the edge of the screen.
  canPass(x, y, d) {
    switch(d) {
      case Direction.DOWN:
        if (y >= $gameMap.height() - 2) return false;
        break;
      case Direction.LEFT:
        if (x < 2) return false;
        break;
      case Direction.RIGHT:
        if (x >= $gameMap.width() - 2) return false;
        break;
      case Direction.UP:
        if (y < 2) return false;
        break;
    }

    return Objects.Creature.prototype.canPass.call(this, x, y, d);
  }
};
