//-----------------------------------------------------------------------------
// Game_Shiba
//
// The game object class for shiba dog events

Objects.Shiba = class Shiba extends Objects.Dog {
  constructor() {
    super(...arguments);
    this._moveType = 1;
    this._moveFrequency = 5;
  }

  initMembers() {
    super.initMembers();
    this._animalType = 'shiba';
    this._moveTypeDelay = 0;
  }

  playAnimalSound() {
    Managers.Sound.playDog();
  }

  startRunning() {
    this._moveSpeed = 3.5;
    this._characterIndex = 1;
    this._moveTypeDelay = Utils.getFrameCount(10);

    this.playAnimalSound();
  }

  startPeeing() {
    this._characterIndex = 4;
    this._stepAnime = true;
    this._moveTypeDelay = Utils.getFrameCount(120);
  }

  makeRunAwayRoute(duration) {
    const list = super.makeRunAwayRoute(duration);
    list.push({
      code: Routes.ROUTE_SCRIPT,
      parameters: ['this._characterIndex = 0; this.restoreSpeed(); this.moveTypeRandom();']
    });

    return list;
  }

  runAwayFromPlayer(duration) {
    this._characterIndex = 1;
    this._moveSpeed = 3.5;
    super.runAwayFromPlayer(duration);
    this.playAnimalSound();
  }

  startScratching() {
    if (this._direction == 2) {
      this._direction = 4;
    } else if (this._direction == 8) {
      this._direction = 6;
    }

    this._moveSpeed = 8;
    this._characterIndex = 5;
    this._stepAnime = true;
    this._moveTypeDelay = Utils.getFrameCount(120);
  }

  startBellyDance() {
    this._characterIndex = 6;
    this._stepAnime = true;
    this._moveTypeDelay = Utils.getFrameCount(120);
  }

  randomAnimation() {
    switch (Math.randomInt(5)) {
      case 0:
        this.startPeeing();
        break;
      case 1:
        this.startScratching();
        break;
      case 2:
        this.startBellyDance();
        break;
      default :
        this.moveRandom();
        break;
    }  
  }

  moveTypeRandomRun(canStop) {
    if (canStop && Math.randomInt(10) == 4) {
      this.restoreSpeed();
      this._characterIndex = 0;
      return;
    }

    this.moveRandom();
  }

  moveRandom() {
    const availableDirections = [];
    if (this._direction !== Direction.UP) {
      availableDirections.push(Direction.DOWN);
    }

    if (this._direction !== Direction.LEFT) {
      availableDirections.push(Direction.RIGHT);
    }

    if (this._direction !== Direction.RIGHT) {
      availableDirections.push(Direction.LEFT);
    }

    if (this._direction !== Direction.DOWN) {
      availableDirections.push(Direction.UP);
    }

    availableDirections.push(this._direction);
    availableDirections.push(this._direction);
    availableDirections.push(this._direction);

    const idx = Math.randomInt(availableDirections.length);

    const d = availableDirections[idx];
    if (this.canPass(this.x, this.y, d)) {
      this.moveStraight(d);
    }
  }

  doPeeEffects() {
    const x = Math.round(this.x);
    const y = Math.round(this.y);

    const tile = TileHelper.newTile(x, y);

    const farmObject = Managers.FarmObjects.getFarmObject($gameMap._mapId, tile.x, tile.y);
    if (!farmObject) return;
    if (farmObject.state == Constants.FarmObjectState.NONE) return;
    if (!farmObject.tilled) return;
    if (farmObject.watered) return;
    if (farmObject.isFlower()) return;

    farmObject.watered = true;
    farmObject.updateEvents();
  }

  endMoveType() {
    if (this._characterIndex == 4) {
      this.doPeeEffects();
    }

    this.restoreSpeed();
    this._characterIndex = 0;
    this._stepAnime = false;
  }

  moveTypeRandom() {
    if (this._moveTypeDelay > 0) {
      this._moveTypeDelay--;
      if (this._moveTypeDelay === 0) {
        this.endMoveType();
      } else {
        if (this._characterIndex === 1) {
          this.moveTypeRandomRun(false);
        }
      }
      return;
    }

    this._stepAnime = false;
    
    if (this._characterIndex === 1) {
      this.moveTypeRandomRun(true);
      return;
    }

    this.restoreSpeed();

    switch (Math.randomInt(12)) {
      case 0:
      case 1:
        this.moveRandom();
        break;
      case 2:
        this.stopForAWhile(Math.randomInt(600));
        break;
      case 3:
        this.startRunning();
        this.moveForward();
        break;
      case 4:
      case 5:
        this.randomAnimation();
        break;
      default :
        this.moveForward();
        break;
    }
  }

  restoreSpeed() {
    this._moveSpeed = 2;
    this._moveFrequency = 5;
  }

  restoreMoveType() {
    super.restoreMoveType();
    this._letPlayerWalkThroughThisEvent = true;
  }
};

