//-----------------------------------------------------------------------------
// Game_Sheep
//
// The game object class for sheep events

Objects.Sheep = class Sheep extends Objects.PushableAnimal {
  initMembers() {
    Objects.Animal.prototype.initMembers.call(this);
    this._animalType = 'sheep';
    this._moveType = 1;
  }

  getHitboxWidth() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 16;
    } else {
      return 24;
    }
  }

  getHitboxHeight() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 24;
    } else {
      return 8;
    }
  }
  getHitboxY() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 16;
    }
  }

  characterName() {
    if (this._creatureData.hasWool) {
      return this._characterName;
    }

    return `${ this._characterName }2`;
  }

  moveStraight(d, maxStepSize) {
    const oldD = this._direction;

    this.setDirection(d);

    Objects.Animal.prototype.moveStraight.call(this, d, maxStepSize);

    if (!this.isMovementSucceeded()) {
      this.setDirection(oldD);
    }
  }

  start(activatedByMouse = false) {
    this.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('talk_to_sheep');
    return true;
  }
};