Objects.ScenarioEvent = class ScenarioEvent extends Objects.CustomEvent {
  initialize() {
    super.initialize(...arguments);
  }

  hasAnythingToRun(activatedByMouse = false) {
    return false;
  }

  isValid(x, y) {
    if ($gameMap.isValid(x, y)) return true;

    // Adds an extra valid position for the scenario events, so that they appear to move out of screen.

    switch(this._direction) {
      case Direction.RIGHT :
        return $gameMap.isValid(x - 1, y);
      case Direction.LEFT :
        return $gameMap.isValid(x + 1, y);
      case Direction.UP :
        return $gameMap.isValid(x, y + 1);
      case Direction.DOWN :
        return $gameMap.isValid(x, y - 1);
      default :
        return false;
    }
  }
};