//-----------------------------------------------------------------------------
// Game_PushableObject
//
// The game object class for creature events

Objects.PushableObject = class PushableObject extends Objects.CustomEvent {
  initMembers() {
    Objects.CustomEvent.prototype.initMembers.call(this);
    this.pushCount = 0;
  }

  hasAnythingToRun(activatedByMouse = false) {
    return true;
  }

  start(activatedByMouse = false) {
    Managers.CommonEvent.playEvent('player_start_pushing');
    window.objectBeingPushed = this;
    return true;
  }

  continuePushing() {
    this._moveSpeed = 2;
    this.moveStraight($gamePlayer._direction);
    this.pushCount = 0;

    if (this.isMovementSucceeded()) {
      if ($gamePlayer.canPass($gamePlayer._x, $gamePlayer._y, $gamePlayer._direction)) {
        Managers.CommonEvent.playEvent('player_move_while_pushing');
      } else {
        Managers.CommonEvent.playEvent('player_stop_pushing');
      }

      Managers.Sound.playDrag();
      Managers.Map.afterDraggingObject(this);
    } else {
      Managers.CommonEvent.playEvent('player_stop_pushing');
    }
  }

  continuePushingIfNeeded() {
    let shouldContinue = false;
    switch($gamePlayer._direction) {
      case Direction.LEFT :
        shouldContinue = Engine.Input.isPressed('left');
        break;
      case Direction.RIGHT :
        shouldContinue = Engine.Input.isPressed('right');
        break;
      case Direction.UP :
        shouldContinue = Engine.Input.isPressed('up');
        break;
      case Direction.DOWN :
        shouldContinue = Engine.Input.isPressed('down');
        break;
    }

    if (shouldContinue) {
      this.continuePushing();
    } else {
      Managers.CommonEvent.playEvent('player_stop_pushing');
    }
  }

  isCollidedWithEvents(x, y) {
    const events = $gameMap.eventsXyNt(x, y);
    const collidedWithEvents = events.some(event => event.isNormalPriority());

    if (collidedWithEvents) return true;

    const farmObjects = $gameMap.farmObjectsXy(x, y);
    const collidedWithFarmObjects = farmObjects.some(event => event.isNormalPriority());

    if (collidedWithFarmObjects) return true;

    return false;
  }
};
