require('./Animal');

//-----------------------------------------------------------------------------
// Game_PushableAnimal
//
// The game object class for pushable animals

Objects.PushableAnimal = class PushableAnimal extends Objects.Animal {
  get hitboxX() {
    return this.getHitboxX();
  }
  set hitboxX(value) {
    this.setHitboxX(value);
  }
  get hitboxY() {
    return this.getHitboxY();
  }
  set hitboxY(value) {
    this.setHitboxY(value);
  }
  get hitboxWidth() {
    return this.getHitboxWidth();
  }
  set hitboxWidth(value) {
    this.setHitboxWidth(value);
  }
  get hitboxHeight() {
    return this.getHitboxHeight();
  }
  set hitboxHeight(value) {
    this.setHitboxHeight(value);
  }
  get offsetX() {
    return this.getOffsetX();
  }
  set offsetX(value) {
    this.setOffsetX(value);
  }
  get offsetY() {
    return this.getOffsetY();
  }
  set offsetY(value) {
    this.setOffsetY(value);
  }

  initMembers() {
    Objects.CustomEvent.prototype.initMembers.call(this);
    this.pushCount = 0;
  }

  hasAnythingToRun(activatedByMouse = false) {
    return true;
  }

  push() {
    // this.moveStraight($gamePlayer._direction);
    // this.pushCount = 0;

    // if (!this.isMovementSucceeded()) {
    //   this.checkIfShouldTeleport($gamePlayer._direction);
    // }
  }

  checkIfShouldTeleport(d) {
    if (this._isTeleporting) return;

    if ($gameMap._realMapId == Maps.BARN) {
      BarnMap.checkAnimalPosition(this);
      return;
    }

    const tile = TileHelper.getSmartFrontTile(1, this, d);
    if (tile) {
      const objects = $gameMap.farmObjectsXy(tile.x, tile.y);

      if (objects.length === 0) return;

      for (const object of objects) {
        if (!object) continue;
        const data = object._farmObjectData;
        if (!data) continue;

        if (data.type != Constants.FarmObjectState.BARN) continue;

        const mapId = data.targetMapId;
        const animalData = this._creatureData;

        this._isTeleporting = true;

        object.doDoorAnimation();

        const animalEvent = this;

        $gameTemp.setTimeout(() => { //jshint ignore:line
          object.setThrough(true);
          object.moveStraight(8);

          Managers.Creatures.moveAnimal(animalData, mapId, 10, 13, Direction.UP);
          $gameTemp.setTimeout(() => {
            animalEvent.erase();
            object.doCloseDoorAnimation();
          }, 6);
        }, 18);

        return;
      }
    }
  }
};
