//-----------------------------------------------------------------------------
// Game_Pig
//
// The game object class for pig events

Objects.Pig = class Pig extends Objects.PushableAnimal {
  initMembers() {
    Objects.Animal.prototype.initMembers.call(this);
    this._animalType = 'pig';
    this._moveType = 1;
  }

  getHitboxWidth() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 42;
    } else {
      return 80;
    }
  }

  getHitboxX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 16;
    }
  }

  getOffsetX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 16;
    }
  }

  moveStraight(d, maxStepSize) {
    const oldD = this._direction;

    this.setDirection(d);

    Objects.Animal.prototype.moveStraight.call(this, d, maxStepSize);

    if (!this.isMovementSucceeded()) {
      this.setDirection(oldD);
    }
  }

  start(activatedByMouse = false) {
    this.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('talk_to_pig');
    return true;
  }
};
