require('./Villager');

//-----------------------------------------------------------------------------
// Game_Monkey
//
// The game object class for monkey events

Objects.Monkey = class Monkey extends Objects.Villager {
  initMembers() {
    super.initMembers();
    this._characterName = 'animals/monkeys2';
  }

  setEventTypeData() {
    super.setEventTypeData();
    this.restoreMoveType();
  }

  playAnimalSound() {
    
  }

  canGiftItem(itemId) {
    if (itemId == 'banana') return true;
    if (itemId == 'apple') return true;
    if (itemId == 'tomato') return true;
    if (itemId == 'carrot') return true;
    if (itemId == 'turnip') return true;
    if (itemId == 'pumpkin') return true;
    if (itemId == 'orange') return true;
    if (itemId == 'watermelon') return true;
    if (itemId == 'jasmine') return true;
    if (itemId == 'peach') return true;
    if (itemId == 'cocoa') return true;
    
    return false;
  }

  doWildAnimalReaction() {
    this.doAnimalDropReaction();
    Managers.CommonEvent.playEvent('monkey_reaction');
  }

  doWildAnimalNaming() {
    this.doAnimalDropReaction();

    window.animalBeingNamed = this._creatureData;
    Managers.CommonEvent.playEvent('monkey_naming');
  }

  restoreMoveType() {
    // this._moveSpeed = 3;
    // this._moveType = 0;
    // this._moveFrequency = 3;
    this._letPlayerWalkThroughThisEvent = true;
    this._stepAnime = true;
    this._moveFrequency = 3;
  }

  movingCharacterName() {
    return 'animals/monkeys';
  }

  stoppedCharacterName() {
    return 'animals/monkeys2';
  }
};
