require('engine/objects/Event');

Objects.MapEvent = class MapEvent extends Objects.Event {
  getRealHitboxX() {
    if (this._hitboxX === undefined) {
      let size = this.findNoteTagValue('hitboxX');
      if (size !== undefined) {
        size = parseFloat(size, 10);
      }

      if (typeof(size) == "number") {
        this._hitboxX = size;
      } else {
        this._hitboxX = 0;
      }

      this._canClearHitboxX = true;
    }

    return this._hitboxX;
  }

  getRealHitboxY() {
    if (this._hitboxY === undefined) {
      let size = this.findNoteTagValue('hitboxY');
      if (size !== undefined) {
        size = parseFloat(size, 10);
      }

      if (typeof(size) == "number") {
        this._hitboxY = size;
      } else {
        this._hitboxY = 0;
      }

      this._canClearHitboxY = true;
    }

    return this._hitboxY;
  }

  getRealHitboxWidth() {
    if (this._hitboxWidth === undefined) {
      let size = this.findNoteTagValue('hitboxWidth');
      if (size !== undefined) {
        size = parseFloat(size, 10);
      }

      if (typeof(size) == "number") {
        this._hitboxWidth = size;
      } else {
        this._hitboxWidth = 1;
      }

      this._canClearHitboxWidth = true;
    }

    return this._hitboxWidth;
  }

  getRealHitboxHeight() {
    if (this._hitboxHeight === undefined) {
      let size = this.findNoteTagValue('hitboxHeight');
      if (size !== undefined) {
        size = parseFloat(size, 10);
      }

      if (typeof(size) == "number") {
        this._hitboxHeight = size;
      } else {
        this._hitboxHeight = 1;
      }
      this._canClearHitboxHeight = true;
    }

    return this._hitboxHeight;
  }

  isSingleImage() {
    if (this._singleImage === undefined) {
      const singleImage = this.findNoteTagValue('singleImage');
      this._singleImage = singleImage !== undefined;
    }

    return this._singleImage;
  }

  shouldDisableOwnBalloon() {
    if (this._disableOwnBalloon === undefined) {
      this._disableOwnBalloon = this.findNoteTagValue('noballoon');
    }

    return this._disableOwnBalloon;
  }

  // Adds a method that searches for a notetag value on all comments of the page
  findNoteTagValue(notetag) {
    const page = this.page();
    if (page === undefined) return false;

    if (page.meta === undefined) {
      MVC.extractEventMeta(this);
    }

    let result;
    if (page.meta !== undefined) {
      result = MVC.getProp(page.meta, notetag);
    }

    if (result === undefined) {
      return MVC.getProp(this.event().meta, notetag);
    }
    else {
      return result;
    }
  }

  shouldAcceptMouseDown() {
    if (this._shouldAcceptMouseDown !== undefined) {
      return this._shouldAcceptMouseDown === true;
    }

    this._shouldAcceptMouseDown = this.findNoteTagValue('acceptMouseDown');
  }
};
