//-----------------------------------------------------------------------------
// Game_Horse
//
// The game object class for horse events

Objects.Horse = class Horse extends Objects.PushableAnimal {
  initMembers() {
    Objects.Animal.prototype.initMembers.call(this);
    this._animalType = 'horse';
  }

  getHitboxWidth() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 12;
    } else {
      return 40;
    }
  }

  getHitboxHeight() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 32;
    } else {
      return 12;
    }
  }

  getHitboxX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 8;
    } else {
      return -12;
    }
  }

  getHitboxY() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 20;
    }
  }

  getOffsetX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 0;
    }
  }

  moveStraight(d, maxStepSize) {
    const oldD = this._direction;

    this.setDirection(d);

    Objects.Animal.prototype.moveStraight.call(this, d, maxStepSize);

    if (!this.isMovementSucceeded()) {
      this.setDirection(oldD);
    }
  }

  canGiftItem(itemId) {
    if (itemId == 'hay') return true;
    if (itemId == 'grass') return true;
    if (itemId == 'grain') return true;
    if (itemId == 'corn') return true;
    if (itemId == 'carrot') return true;
    if (itemId == 'apple') return true;

    return false;
  }

  start(activatedByMouse = false) {
    this.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('horse_interaction');
    return true;
  }
};
