require('./PushableAnimal');

//-----------------------------------------------------------------------------
// Game_Goat
//
// The game object class for goat events

Objects.Goat = class Goat extends Objects.PushableAnimal {
  initMembers() {
    Objects.Animal.prototype.initMembers.call(this);
    this._animalType = 'goat';
  }

  getHitboxWidth() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 16;
    } else {
      return 32;
    }
  }

  getHitboxHeight() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 32;
    } else {
      return 8;
    }
  }

  getHitboxX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 8;
    } else {
      return 0;
    }
  }

  getHitboxY() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 16;
    }
  }

  getOffsetX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 0;
    }
  }

  getOffsetY() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return -4;
    }
  }

  moveStraight(d, maxStepSize) {
    const oldD = this._direction;

    this.setDirection(d);

    Objects.Animal.prototype.moveStraight.call(this, d, maxStepSize);

    if (!this.isMovementSucceeded()) {
      this.setDirection(oldD);
    }
  }

  canGiftItem(itemId) {
    if (itemId == 'hay') return true;
    if (itemId == 'grass') return true;
    if (itemId == 'grain') return true;
    if (itemId == 'corn') return true;
    if (itemId == 'apple') return true;
    if (itemId == 'banana') return true;
    if (itemId == 'cabbage') return true;
    if (itemId == 'lettuce') return true;
    if (itemId == 'spinach') return true;
    if (itemId == 'weeds') return true;
    if (itemId == 'red-weeds') return true;
    if (itemId == 'yellow-weeds') return true;
    if (itemId == 'sunflower-seeds') return true;

    return false;
  }

  start(activatedByMouse = false) {
    this.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('goat_interaction');
    return true;
  }
};
