//-----------------------------------------------------------------------------
// Game_Dog
//
// The game object class for dog events

Objects.Dog = class Dog extends Objects.SmallAnimal {
  constructor() {
    super(...arguments);
    this._moveType = 1;
  }

  initMembers() {
    super.initMembers();
    this._animalType = 'dog';
  }

  playAnimalSound() {
    Managers.Sound.playDog();
  }

  canGiftItem(itemId) {
    if (itemId == 'orange') return true;
    if (itemId == 'apple') return true;
    if (itemId == 'banana') return true;
    if (itemId == 'watermelon') return true;
    if (itemId == 'carrot') return true;
    if (itemId == 'potato') return true;
    if (itemId == 'tomato') return true;
    if (itemId == 'pet-food') return true;
    
    return false;
  }

  doWildAnimalReaction() {
    this.doAnimalDropReaction();
    Managers.CommonEvent.playEvent('dog_reaction');
  }

  doWildAnimalNaming() {
    this.doAnimalDropReaction();

    window.animalBeingNamed = this._creatureData;
    Managers.CommonEvent.playEvent('dog_naming');
  }
};
