require('engine/objects/Event');

Objects.CustomEvent = class CustomEvent extends Objects.Event {
  initialize(mapId, eventId, eventData) {
    this._eventData = eventData;
    super.initialize(mapId, eventId);
  }

  event() {
    return this._eventData;
  }

  revive(data) {
    return new Objects.CustomEvent(data.mapId, data.id, data.eventData);
  }

  checkEventTriggerAuto() {
  }

  // Custom events can have different hitboxWidth per page 
  getRealHitboxWidth() {
    if (!this._dynamicHitbox) {
      return super.getRealHitboxWidth();
    }

    const page = this.page();
    if (page && page._hitboxWidth !== undefined) {
      return page._hitboxWidth || 1;
    }

    return super.getRealHitboxWidth();
  }
};