require('./CustomEvent');

//-----------------------------------------------------------------------------
// Game_Creature
//
// The game object class for creature events

Objects.Creature = class Creature extends Objects.CustomEvent {
  get allowMovementOnFrozenTime() {
    return this._allowMovementOnFrozenTime;
  }
  set allowMovementOnFrozenTime(value) {
    this._allowMovementOnFrozenTime = value;
  }

  initialize(...args) {
    super.initialize(...args);
    this._letPlayerWalkThroughThisEvent = false;
    this.restoreMoveType();
  }

  initMembers() {
    super.initMembers();
    this.allowMovementOnFrozenTime = true;
    this._creatureData = undefined;
  }

  preventMovement() {
    if ($gameMessage.isBusy() && !$gameSystem.isPlayingCutscene()) {
      return true;
    }

    if (this.allowMovementOnFrozenTime !== true) {
      if (Managers.Time.isInternallyPaused()) {
        return true;
      }
    }

    return false;
  }

  updateMove() {
    if (this.preventMovement()) {
      return;
    }

    super.updateMove(...arguments);
  }

  updateAnimationCount() {
    if (this.preventMovement()) {
      return;
    }

    super.updateAnimationCount(...arguments);
  }

  reactToPlayerMovement() {

  }

  setCreatureData(creatureData) {
    this._creatureData = creatureData;
  }

  storeCreatureDataOnVariables() {
    Variables.creatureName = this._creatureData.creatureName;
    Variables.creatureHomeMapId = this._creatureData.homeMapId;
    Variables.creatureHomeX = this._creatureData.homeX;
    Variables.creatureHomeY = this._creatureData.homeY;
    Variables.creatureId = this._creatureData.id;
    Variables.creatureX = this._creatureData.x;
    Variables.creatureY = this._creatureData.y;
    Variables.creatureMapId = this._creatureData.mapId;
    Variables.creatureType = this._creatureData.type;
    Variables.creatureAge = this._creatureData.age;

    Variables.creatureEvent = this;
    Variables.creatureData = this._creatureData;
  }

  restoreMoveType() {
    this._moveType = 0;
    this._moveFrequency = 3;
  }

  getMetaOffsetX() {
    return undefined;
  }

  getMetaOffsetY() {
    return undefined;
  }

  giveGift() {
    const creatureData = this._creatureData;
    if (!creatureData) return false;

    creatureData._gotGiftToday = true;
    creatureData.friendship = (creatureData.friendship || 0);

    this.increaseFriendshipForGift(creatureData, Managers.Items.selectedItem.id);
    Managers.Items.loseUnitOfSelectedItem();

    this.requestBalloon(Balloons.HEART);
    this.playAnimalSound();
    return true;
  }

  increaseFriendshipForGift(creatureData/*, itemId*/) {
    creatureData.friendship += 20;
  }

  canGiftItem() /*itemId*/{
    return false;
  }

  checkGifts(simulation) {
    if (Switches.isInsideFestival) return false;
    if (!Managers.Items.isHoldingItem()) return false;
    const itemId = Managers.Items.selectedItem.id;
    if (!this.canGiftItem(itemId)) return false;

    const creatureData = this._creatureData;
    if (!creatureData) return false;

    if (creatureData._gotGiftToday) return false;

    if (simulation) return true;

    return this.giveGift(Managers.Items.selectedItem.id);
  }

  checkMapPassable(x, y/*, d*/) {
    const regionId = $gameMap.regionId(x, y);
    if (regionId == Region.BLOCK_ANIMALS) return false;
    if (regionId == Region.STAIR_TILES) return false;

    const tag = $gameMap.terrainTag(x, y);
    if (tag == TerrainTags.ICE) return false;

    return super.checkMapPassable(...arguments);
  }
};
