//-----------------------------------------------------------------------------
// Game_Cow
//
// The game object class for cow events

Objects.Cow = class Cow extends Objects.PushableAnimal {
  initMembers() {
    Objects.Animal.prototype.initMembers.call(this);
    this._animalType = 'cow';
  }

  getHitboxWidth() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 32;
    } else {
      return 48;
    }
  }

  getHitboxHeight() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 48;
    } else {
      return 16;
    }
  }

  getHitboxX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 8;
    } else {
      return -8;
    }
  }

  getHitboxY() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 8;
    } else {
      return 8;
    }
  }

  moveStraight(d, maxStepSize) {
    const oldD = this._direction;

    this.setDirection(d);

    Objects.Animal.prototype.moveStraight.call(this, d, maxStepSize);

    if (!this.isMovementSucceeded()) {
      this.setDirection(oldD);
    }
  }

  canGiftItem(itemId) {
    // if (itemId == 'hay') return true;
    if (itemId == 'grass') return true;
    if (itemId == 'grain') return true;
    if (itemId == 'corn') return true;

    return false;
  }

  start(activatedByMouse = false) {
    this.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('cow_interaction');
    return true;
  }
};