//-----------------------------------------------------------------------------
// Game_Chicken
//
// The game object class for chicken events

Objects.Chicken = class Chicken extends Objects.Animal {
  initMembers() {
    super.initMembers();
    this._animalType = 'chicken';
  }

  restoreSpeed() {
    this._moveSpeed = 1;
  }

  start(activatedByMouse = false) {
    if (this.checkGifts()) {
      return true;
    }

    if (activatedByMouse && !TouchInput.isTriggered()) return false;

    if ($gamePlayer.isRiding()) return false;
    if (Managers.Items._specialItem) return false;
    
    this.chat();
    return true;
  }

  chat() {
    this.doAnimalDropReaction();
  }

  reactToPlayerMovement() {
    if (!this.isMoving()) {
      this.moveAwayFromPlayer();
    }
  }

  setCreatureData(creatureData) {
    super.setCreatureData(...arguments);
    this._animalType = creatureData._type;

    this._letPlayerWalkThroughThisEvent = true;
  }

  canGiftItem(itemId) {
    if (itemId == 'corn') return true;
    if (itemId == 'weeds') return true;
    if (itemId == 'grass') return true;
    if (itemId == 'red-weeds') return true;
    if (itemId == 'yellow-weeds') return true;
    // if (itemId == 'chicken-feed') return true;
    if (itemId == 'cabbage') return true;
    if (itemId == 'spinach') return true;
    if (itemId == 'lettuce') return true;
    if (itemId == 'sunflower-seeds') return true;
    if (itemId == 'yogurt') return true;

    return false;
  }

  doAnimalDropReaction() {
    if (this._creatureData) {
      if (this._creatureData.spokenTo) {
        this.requestBalloon(Balloons.MUSIC);
      } else {
        this.requestBalloon(Balloons.HEART);
      }

      this._creatureData.spokenTo = true;
    }

    this.playAnimalSound();
  }

  playAnimalSound() {
    if (this._animalType.includes('chicken')) {
      Managers.Sound.playChicken();
    }
  }

  restoreMoveType() {
    this._moveType = 1;
    this._moveFrequency = 3;
  }
};
