//-----------------------------------------------------------------------------
// Game_Cat
//
// The game object class for cat events

Objects.Cat = class Cat extends Objects.SmallAnimal {
  initMembers() {
    super.initMembers();
  }

  setEventTypeData() {
    super.setEventTypeData();
    this.restoreMoveType();
  }

  playAnimalSound() {
    Managers.Sound.playCat();
  }

  canGiftItem(itemId) {
    if (itemId == 'tiger-barb') return true;
    if (itemId == 'tuna') return true;
    if (itemId == 'walleye') return true;
    if (itemId == 'pickerel') return true;
    if (itemId == 'bass') return true;
    
    return false;
  }

  doWildAnimalReaction() {
    this.doAnimalDropReaction();
    Managers.CommonEvent.playEvent('cat_reaction');
  }

  doWildAnimalNaming() {
    this.doAnimalDropReaction();

    window.animalBeingNamed = this._creatureData;
    Managers.CommonEvent.playEvent('cat_naming');
  }

  restoreMoveType() {
    this._moveSpeed = 2;
    this._moveType = 1;
    this._moveFrequency = 5;
  }
};
