require('./PushableAnimal');

//-----------------------------------------------------------------------------
// Game_Bull
//
// The game object class for bull events

Objects.Bull = class Bull extends Objects.PushableAnimal {
  initMembers() {
    Objects.Animal.prototype.initMembers.call(this);
    this._animalType = 'bull';
  }

  moveStraight(d, maxStepSize) {
    const oldD = this._direction;

    this.setDirection(d);

    Objects.Animal.prototype.moveStraight.call(this, d, maxStepSize);

    if (!this.isMovementSucceeded()) {
      this.setDirection(oldD);
    }
  }

  start(activatedByMouse = false) {
    this.storeCreatureDataOnVariables();
    Managers.CommonEvent.playEvent('talk_to_bull');
    return true;
  }

  restoreMoveType() {
    this._moveFrequency = 3;
  }

  getHitboxWidth() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 42;
    } else {
      return 80;
    }
  }

  getHitboxX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 16;
    }
  }

  getOffsetX() {
    if (this._direction == Direction.DOWN || this._direction == Direction.UP) {
      return 0;
    } else {
      return 16;
    }
  }
};
