require('./Creature');

//-----------------------------------------------------------------------------
// Objects.Animal
//
// The base game object class for animal events

Objects.Animal = class Animal extends Objects.Creature {
  initMembers() {
    super.initMembers();
    this.allowMovementOnFrozenTime = false;
    this.restoreSpeed();

    this._animalType = undefined;
  }

  actor() {
    return this._creatureData.actor();
  }

  restoreSpeed() {
    this._moveSpeed = 1;
  }

  restoreMoveType() {
    this._moveFrequency = 3;
    this._moveType = 1;
  }

  start(activatedByMouse = false) {
    return true;
  }

  sendHome() {
    this.requestAnimation(Constants.TELEPORT_ANIMATION);
    this._moveType = 0;
    this._x = this._realX;
    this._y = this._realY;

    const animal = this;
    const data = animal._creatureData;

    Managers.Creatures.moveAnimal(data, data.homeMapId, data.homeX, data.homeY, Direction.DOWN);

    $gameTemp.setTimeout(() => {
      animal.erase();
    }, 6);
  }

  sendOutside() {
    const barnData = Managers.FarmObjects.findBarnData($gameMap._mapId);
    if (!barnData) return;

    this.requestAnimation(Constants.TELEPORT_ANIMATION);
    this._moveType = 0;
    this._x = this._realX;
    this._y = this._realY;

    const animal = this;
    const data = animal._creatureData;

    Managers.Creatures.moveAnimal(data, barnData.mapId, barnData.x, barnData.y + 2, Direction.DOWN);

    $gameTemp.setTimeout(() => {
      animal.erase();
    }, 6);
  }

  hasAnythingToRun(activatedByMouse = false) {
    return true;
  }

  myIntendedStepSize() {
    return 1;
  }

  moveStraight(d, maxStepSize) {
    super.moveStraight(d, maxStepSize);

    if (this.isMovementSucceeded()) {
      Managers.Creatures.moveAnimal(this._creatureData, $gameMap._mapId, this._x, this._y, this._direction);
    }
  }

  canPass(x, y, d) {
    const can = Objects.Creature.prototype.canPass.apply(this, arguments);
    if (!can) {
      return can;
    }

    const stepSize = this.myStepSize();
    const x2 = this.roundFractionXWithDirection(x, d, stepSize);
    const y2 = this.roundFractionYWithDirection(y, d, stepSize);

    let foundBlockingRegion = false;
    const animal = this;
    this.runForAllPositions(x2, y2, (newX, newY) => {
      if ($gameMap.regionId(newX, newY) == Region.SUPER_PROTECTED) {
        if (!animal.isTouchingRegion(Region.SUPER_PROTECTED)) {
          foundBlockingRegion = true;
        }

        return false;
      }
    });

    if (foundBlockingRegion) return false;

    return can;
  }

  doAnimalDropReaction() {
    if (this._creatureData) {
      if (this._creatureData.friendship < 0) {
        this.requestBalloon(Balloons.SILENCE);
      } else {
        if (this._creatureData.spokenTo) {
          this.requestBalloon(Balloons.MUSIC);
        } else {
          this.requestBalloon(Balloons.HEART);
        }
      }

      this._creatureData.spokenTo = true;
    }

    this.playAnimalSound();
  }
};

addPixelMovement(Objects.Animal);
