require('game/models/BaseModel');

Models.Weeds = class Weeds extends Models.BaseModel {
  static get modelName() {
    return 'weed';
  }

  static defaultData(gameObject) {
    let spriteName = 'objects1x';
    let spriteIndex = 6;
    let direction = Direction.DOWN;
    let pattern = 2;
    let tileId;

    const season = Managers.Time.mapMonth;

    if (gameObject.hp === undefined || gameObject.hp >= 5) {
      spriteName = 'tileset';
      tileId = 29;
    } else {
      spriteIndex = 2;
      switch(gameObject.hp) {
        case 4:
          direction = Direction.DOWN;
          break;
        case 3:
          direction = Direction.LEFT;
          break;
        case 2:
          direction = Direction.RIGHT;
          break;
        case 1:
          direction = Direction.UP;
          break;
        default:
          return {};
      }

      if (season == Seasons.FALL) {
        pattern = 1;
      }
    }

    return {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 0.6,
      hitboxHeight: 0.25,
      useCustomTileId: Boolean(tileId),
      spriteName,
      spriteIndex,
      tileId,
      direction,
      pattern,
      priority: season === Seasons.WINTER ? 0 : 1,
      through: false
    };
  }

  static processGameObjectNewDay(gameObject) {
    if (Managers.Map.mapMonth(gameObject.mapId) == Seasons.WINTER) {
      gameObject.clear();
    }
  }
};