require('game/models/BaseModel');

Models.ThickWeeds = class ThickWeeds extends Models.BaseModel {
  static get modelName() {
    return 'thick-weed';
  }

  static defaultData(gameObject) {
    const tileId = 30;

    return {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 0.6,
      hitboxHeight: 0.25,
      useCustomTileId: true,
      spriteName: 'tileset',
      spriteIndex: 0,
      tileId,
      direction: 2,
      pattern: 0,
      priority: 1,
      through: false
    };
  }

  static processGameObjectNewDay(gameObject) {
    if (Managers.Map.mapMonth(gameObject.mapId) == Seasons.WINTER) {
      gameObject.clear();
    }
  }
};