require('game/models/BaseModel');

Models.TermiteNest = class TermiteNest extends Models.BaseModel {
  static get modelName() {
    return 'termite-nest';
  }

  static defaultData(gameObject) {
    let spriteName = 'objects1x';
    let spriteIndex = 4;
    let direction = Direction.DOWN;
    let pattern = 1;
    let tileId;

    if (gameObject.hp === undefined || gameObject.hp >= 7) {
      spriteName = 'tileset';
      tileId = 14;
    } else {
      spriteIndex = 0;
      switch(gameObject.hp) {
        case 6:
          direction = Direction.DOWN;
          break;
        case 5:
          direction = Direction.LEFT;
          break;
        case 4:
          direction = Direction.RIGHT;
          break;
        case 3:
          direction = Direction.UP;
          break;
        case 2:
          direction = Direction.UP;
          pattern = 2;
          break;
        case 1:
          direction = Direction.DOWN;
          pattern = 2;
          spriteIndex = 4;
          break;
        default:
          return {};
      }
    }

    return {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxHeight: 0.25,
      useCustomTileId: Boolean(tileId),
      spriteName,
      spriteIndex,
      tileId,
      direction,
      pattern,
      priority: 1,
      through: false
    };
  }
};