require('game/models/BaseModel');

Models.Stump = class Stump extends Models.BaseModel {
  static get modelName() {
    return 'stump';
  }

  static defaultData(gameObject) {
    let spriteName = 'objects1x';
    let spriteIndex = 7;
    let direction = Direction.DOWN;
    let pattern = 2;
    let tileId;

    if (gameObject.hp === undefined || gameObject.hp >= 5) {
      spriteName = 'tileset';
      tileId = 13;
    } else {
      spriteIndex = 3;
      switch(gameObject.hp) {
        case 4:
          direction = Direction.DOWN;
          break;
        case 3:
          direction = Direction.LEFT;
          break;
        case 2:
          direction = Direction.RIGHT;
          break;
        case 1:
          direction = Direction.UP;
          break;
        default:
          return {};
      }

      if (Managers.Time.mapMonth == Seasons.WINTER) {
        spriteIndex--;
        pattern = 0;
      }
    }

    return {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxHeight: 0.25,
      useCustomTileId: Boolean(tileId),
      spriteName,
      spriteIndex,
      tileId,
      direction,
      pattern,
      priority: 1,
      through: false
    };
  }
};