require('game/models/BaseModel');

Models.Stone = class Stone extends Models.BaseModel {
  static get modelName() {
    return 'stone';
  }

  static defaultData(gameObject) {
    let spriteName = 'objects1x';
    let spriteIndex = 7;
    let direction = Direction.DOWN;
    const pattern = 0;
    let tileId;

    if (!gameObject._forceEventSprite && (gameObject.hp === undefined || gameObject.hp >= 5)) {
      spriteName = 'tileset';
      tileId = 7;
    } else {
      spriteIndex = 3;
      switch(gameObject.hp) {
        case 4:
          direction = Direction.DOWN;
          break;
        case 3:
          direction = Direction.LEFT;
          break;
        case 2:
          direction = Direction.RIGHT;
          break;
        case 1:
          direction = Direction.UP;
          break;
        default:
          return {};
      }

      if (Managers.Time.mapMonth == Seasons.WINTER) {
        spriteIndex -= 3;
      }
    }

    return {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 0.5,
      hitboxHeight: 0.25,
      useCustomTileId: Boolean(tileId),
      spriteName,
      spriteIndex,
      tileId,
      direction,
      pattern,
      priority: 1,
      through: false
    };
  }
};