require('game/models/BaseModel');

Models.Rock4 = class Rock4 extends Models.BaseModel {
  static get modelName() {
    return 'rock-4';
  }

  static defaultData(gameObject) {
    const data = {
      hitboxX: 0,
      hitboxY: 0.25,
      hitboxWidth: 2,
      hitboxHeight: 0.5,
      offsetX: 16,
      spriteName: 'rocks/{sprite}rock-4',
      spriteIndex: 0,
      direction: 2,
      pattern: 0,
      priority: 1,
      through: false
    };

    if (gameObject.broken) {
      data.hitboxY = 0.5;
      data.hitboxHeight = 0.25;

      if (gameObject.brokenTwice) {
        data.spriteName = 'rocks/{sprite}rock-4-broken2';
        data.hitboxX = 0.5;
        data.hitboxWidth = 1;
      } else {
        data.spriteName = 'rocks/{sprite}rock-4-broken';
        data.hitboxX = 0.25;
        data.hitboxWidth = 1.75;
      }
    }

    return data;
  }
};

Managers.FarmObjects.registerLargeModel(Models.Rock4.modelName);
Managers.FarmObjects.registerWideModel(Models.Rock4.modelName);
Managers.FarmObjects.registerCollisionModel(Models.Rock4.modelName);