require('game/models/BaseModel');

Models.Rock3 = class Rock3 extends Models.BaseModel {
  static get modelName() {
    return 'rock-3';
  }

  static defaultData(gameObject) {
    const data = {
      hitboxX: 0.25,
      hitboxY: 0.5,
      hitboxWidth: 1.25,
      hitboxHeight: 0.25,
      offsetX: 12,
      spriteName: 'rocks/{sprite}rock-3',
      spriteIndex: 0,
      direction: 2,
      pattern: 0,
      priority: 1,
      through: false
    };

    if (gameObject.broken) {
      data.spriteName = 'rocks/{sprite}rock-3-broken';

      data.hitboxX = 0.5;
      data.hitboxWidth = 0.75;
    }

    return data;
  }
};

Managers.FarmObjects.registerLargeModel(Models.Rock3.modelName);
Managers.FarmObjects.registerWideModel(Models.Rock3.modelName);
Managers.FarmObjects.registerCollisionModel(Models.Rock3.modelName);