require('game/models/BaseModel');

Models.Gate = class Gate extends Models.BaseModel {
  static get modelName() {
    return 'gate';
  }

  static defaultData(gameObject) {
    return {
      spriteName: '!gates',
      spriteIndex: 3,
      direction: gameObject.pressed ? 8 : 2,
      pattern: 0,
      priority: 1,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 1,
      hitboxX: 0
    };
  }
};

Models.VerticalGate = class VerticalGate extends Models.BaseModel {
  static get modelName() {
    return 'vertical-gate';
  }

  static defaultData(gameObject) {
    return {
      spriteName: '!gates',
      spriteIndex: 7,
      direction: gameObject.pressed ? 8 : 2,
      pattern: 0,
      priority: 1,

      hitboxHeight: 1,
      hitboxY: 0.25,
      hitboxWidth: 0.125,
      hitboxX: 0.375
    };
  }

};