require('game/models/BaseModel');

/*
  [#]
*/
Models.Fence = class Fence extends Models.BaseModel {
  static get modelName() {
    return 'fence';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      direction: 4,
      pattern: 1,
      priority: 1,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 0.125,
      hitboxX: 0.375
    };
  }
};

/*
  [ ]
  [#]
  [ ] 
*/
Models.FenceVertical = class FenceVertical extends Models.BaseModel {
  static get modelName() {
    return 'fence-vertical';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 4,
      pattern: 0,

      hitboxHeight: 1,
      hitboxY: 0.25,
      hitboxWidth: 0.125,
      hitboxX: 0.375
    };
  }
};

/*
  [ ]  
  [#]
*/
Models.FenceDown = class FenceDown extends Models.BaseModel {
  static get modelName() {
    return 'fence-down';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 4,
      pattern: 2,

      hitboxHeight: 1,
      hitboxY: 0,
      hitboxWidth: 0.125,
      hitboxX: 0.375
    };
  }
};

/*
  [#]
  [ ] 
*/
Models.FenceUp = class FenceUp extends Models.BaseModel {
  static get modelName() {
    return 'fence-up';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 1,
      priority: 1,
      direction: 4,
      pattern: 0,

      hitboxHeight: 1,
      hitboxY: 0.25,
      hitboxWidth: 0.125,
      hitboxX: 0.375
    };
  }
};

/*
  [ ][#]
*/
Models.FenceRight = class FenceRight extends Models.BaseModel {
  static get modelName() {
    return 'fence-right';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 8,
      pattern: 2,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 0.5,
      hitboxX: 0
    };
  }
};

/*
  [#][ ]
*/
Models.FenceLeft = class FenceLeft extends Models.BaseModel {
  static get modelName() {
    return 'fence-left';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 8,
      pattern: 0,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 0.5,
      hitboxX: 0.5
    };
  }
};

/*
  [ ]
  [#][ ]
*/
Models.FenceBottomLeft = class FenceBottomLeft extends Models.BaseModel {
  static get modelName() {
    return 'fence-bottom-left';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 6,
      pattern: 0,

      hitboxHeight: 1,
      hitboxY: 0,
      hitboxWidth: 0.125,
      hitboxX: 0.375
    };
  }
};

/*
     [ ]
  [ ][#]
*/
Models.FenceBottomRight = class FenceBottomRight extends Models.BaseModel {
  static get modelName() {
    return 'fence-bottom-right';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 6,
      pattern: 2,

      hitboxHeight: 1,
      hitboxY: 0,
      hitboxWidth: 0.25,
      hitboxX: 0.25
    };
  }
};

/*
  [#][ ]
  [ ]
*/
Models.FenceTopLeft = class FenceTopLeft extends Models.BaseModel {
  static get modelName() {
    return 'fence-top-left';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 2,
      pattern: 0,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 0.5,
      hitboxX: 0.5
    };
  }
};

/*
  [ ][#]
     [ ]
*/
Models.FenceTopRight = class FenceTopRight extends Models.BaseModel {
  static get modelName() {
    return 'fence-top-right';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 2,
      pattern: 2,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 0.5,
      hitboxX: 0
    };
  }
};

/*
  [ ][#][ ]
*/
Models.FenceHorizontal = class FenceHorizontal extends Models.BaseModel {
  static get modelName() {
    return 'fence-horizontal';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 6,
      pattern: 1,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 1,
      hitboxX: 0
    };
  }
};

/*
  [ ][#][ ]
     [ ]
*/
Models.FenceHorizontalUp = class FenceHorizontalUp extends Models.BaseModel {
  static get modelName() {
    return 'fence-horizontal-up';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 2,
      pattern: 1,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 1,
      hitboxX: 0
    };
  }
};

/*
     [ ]
  [ ][#][ ]
*/
Models.FenceHorizontalDown = class FenceHorizontalDown extends Models.BaseModel {
  static get modelName() {
    return 'fence-horizontal-down';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 0,
      priority: 1,
      direction: 8,
      pattern: 1,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 1,
      hitboxX: 0
    };
  }
};

/*
  [ ]
  [#][ ]
  [ ]
*/
Models.FenceVerticalLeft = class FenceVerticalLeft extends Models.BaseModel {
  static get modelName() {
    return 'fence-vertical-left';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 1,
      priority: 1,
      direction: 2,
      pattern: 0,

      hitboxHeight: 1,
      hitboxY: 0,
      hitboxWidth: 0.125,
      hitboxX: 0.375
    };
  }
};

/*
     [ ]
  [ ][#]
     [ ]
*/
Models.FenceVerticalRight = class FenceVerticalRight extends Models.BaseModel {
  static get modelName() {
    return 'fence-vertical-right';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 1,
      priority: 1,
      direction: 2,
      pattern: 2,

      hitboxHeight: 1,
      hitboxY: 0,
      hitboxWidth: 0.125,
      hitboxX: 0.375

    };
  }
};

/*
     [ ]
  [ ][#][ ]
     [ ]
*/
Models.FenceCenter = class FenceCenter extends Models.BaseModel {
  static get modelName() {
    return 'fence-center';
  }

  static defaultData(gameObject) {
    return {
      spriteName: 'fences',
      spriteIndex: 1,
      priority: 1,
      direction: 6,
      pattern: 1,

      hitboxHeight: 0.25,
      hitboxY: 0.75,
      hitboxWidth: 1,
      hitboxX: 0
    };
  }
};
